#include "scene3D.h"
#include "scene3DPoly.h"
#include "manager.h"
#include "utility.h"
#include "input.h"
#include "modeGame.h"
#include "texManager.h"
#include "renderer.h"
#include "camera.h"

// -------- -------- -------- -------- -------- -------- -------- --------
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene3DPoly::Init(void)
{
	//---------------------
	// ϐ̏
	//---------------------
	SetPos(D3DXVECTOR3(0.f, 0.f, 0.f));		// W
	SetSize(D3DXVECTOR3(1.f, 1.f, 1.f));		// TCY
	SetRot(D3DXVECTOR3(0.f, 0.f, 0.f));		// ]
	SetScl(D3DXVECTOR3(1.f, 1.f, 1.f));		// g嗦

	// g_D3Device̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	// _̍쐬
	if (FAILED(pDevice->CreateVertexBuffer(
		sizeof(VERTEX_3D) * NUM_VERTEX,		// ̃TCY
		D3DUSAGE_WRITEONLY,					// gp@(݂̂)
		FVF_VERTEX_3D,						// gp钸_tH[}bg(Ȃ)
		D3DPOOL_MANAGED,					// obt@̊Ǘ@(ɕĂ)
		&m_pVtxBuffer,						// 
		nullptr)))							//
	{
		// sG[Ԃ
		return;
	}

	// obt@bNzAhX擾
	VERTEX_3D* pVtx;
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);

	D3DXVECTOR3 pos = GetPos();
	D3DXVECTOR3 size = GetSize();
	D3DXVECTOR3 scl = GetScl();

	// _W
	pVtx[0].pos = D3DXVECTOR3(-size.x * 0.5f, 0.f, size.z * 0.5f);
	pVtx[1].pos = D3DXVECTOR3(size.x * 0.5f, 0.f, size.z * 0.5f);
	pVtx[2].pos = D3DXVECTOR3(-size.x * 0.5f, 0.f, -size.z * 0.5f);
	pVtx[3].pos = D3DXVECTOR3(size.x * 0.5f, 0.f, -size.z * 0.5f);
	// eNX`W
	pVtx[0].tex = D3DXVECTOR2(0.f, 0.f);
	pVtx[1].tex = D3DXVECTOR2(1.f, 0.f);
	pVtx[2].tex = D3DXVECTOR2(0.f, 1.f);
	pVtx[3].tex = D3DXVECTOR2(1.f, 1.f);
	for (int i = 0; i < 4; i++)
	{
		pVtx[i].nom = D3DXVECTOR3(0.f, 0.f, 1.f);
		pVtx[i].col = D3DCOLOR_RGBA(255, 255, 255, 255);
	}
	// ݒobt@̃AbN
	m_pVtxBuffer->Unlock();
}

// -------- -------- -------- -------- -------- -------- -------- --------
// I
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene3DPoly::Uninit(void)
{
	// Vtxobt@̉
	if (m_pVtxBuffer != nullptr)
	{
		m_pVtxBuffer->Release();
		m_pVtxBuffer = nullptr;
	}
}

// -------- -------- -------- -------- -------- -------- -------- --------
// XV
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene3DPoly::Update(void)
{
	// obt@bNzAhX擾
	VERTEX_3D* pVtx;
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);

	D3DXVECTOR3 size = GetSize();
	int r = GetR();		int g = GetG();
	int b = GetB();		int a = GetA();

	// _W
	pVtx[0].pos = D3DXVECTOR3(-size.x * 0.5f, 0.f, size.z * 0.5f);
	pVtx[1].pos = D3DXVECTOR3(size.x * 0.5f, 0.f, size.z * 0.5f);
	pVtx[2].pos = D3DXVECTOR3(-size.x * 0.5f, 0.f, -size.z * 0.5f);
	pVtx[3].pos = D3DXVECTOR3(size.x * 0.5f, 0.f, -size.z * 0.5f);
	// eNX`W
	pVtx[0].tex = D3DXVECTOR2(0.f, 0.f);
	pVtx[1].tex = D3DXVECTOR2(1.f, 0.f);
	pVtx[2].tex = D3DXVECTOR2(0.f, 1.f);
	pVtx[3].tex = D3DXVECTOR2(1.f, 1.f);

	for (int i = 0; i < 4; i++)
	{
		pVtx[i].col = D3DCOLOR_RGBA(r, g, b, a);
	}

	// ݒobt@̃AbN
	m_pVtxBuffer->Unlock();
}

// -------- -------- -------- -------- -------- -------- -------- --------
// `
// -------- -------- -------- -------- -------- -------- -------- --------
void CScene3DPoly::Draw(void)
{
	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	// ϐ錾
	D3DXMATRIX mtxScl;			// gs
	D3DXMATRIX mtxRot;			// ]s
	D3DXMATRIX mtxPos;			// ss

	// [h}gNX̍쐬
	D3DXMatrixIdentity(&m_mtxWorld);		// sPʍsɂ( g嗦1,0ŏ )
	D3DXMatrixIdentity(&mtxScl);			// 
	D3DXMatrixIdentity(&mtxRot);			// 
	D3DXMatrixIdentity(&mtxPos);			//

	// [hϊsݒ肵ĕϊ
	D3DXVECTOR3 scl = GetScl();
	D3DXVECTOR3 rot = GetRot();
	D3DXVECTOR3 pos = GetPos();
	D3DXMatrixScaling(&mtxScl, scl.x, scl.y, scl.z);					// gs
	D3DXMatrixRotationYawPitchRoll(&mtxRot, rot.y, rot.x, rot.z);		// ]s
	D3DXMatrixTranslation(&mtxPos, pos.x, pos.y, pos.z);				// ss

	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &mtxScl);
	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &mtxRot);
	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &mtxPos);

	// foCXɃ[hϊsݒ
	pDevice->SetTransform(D3DTS_WORLD, &m_mtxWorld);

	// _tH[}bg̐ݒ
	pDevice->SetFVF(FVF_VERTEX_3D);

	// Xg[̐ݒ
	pDevice->SetStreamSource(0, m_pVtxBuffer, 0, sizeof(VERTEX_3D));

	// eNX`̐ݒ
	pDevice->SetTexture(0, CManager::GetTexManager()->GetTexInterface(m_strFilePass));

	// |S̕` // |Š`, |S̐, 擪AhX, TCY
	pDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, NUM_POLYGON);
}

// -------- -------- -------- -------- -------- -------- -------- --------
// 쐬
// -------- -------- -------- -------- -------- -------- -------- --------
CScene3DPoly *CScene3DPoly::Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rot, const D3DXVECTOR3 &size, const std::string &strFilePass, int priority)
{
	// CScene3DPoly̐
	CScene3DPoly *pScene3DPoly;
	pScene3DPoly = new CScene3DPoly(priority);
	pScene3DPoly->Init();

	pScene3DPoly->SetPos(pos);
	pScene3DPoly->SetRot(rot);
	pScene3DPoly->SetSize(size);
	pScene3DPoly->m_strFilePass = strFilePass;

	// eNX`̃Zbg
	CManager::GetTexManager()->SetTex(strFilePass);

	return pScene3DPoly;
}